<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Widged_html extends Cc_widged
{
	public $table_name = 'widged_html';

	public $primary_key = 'id';

	public $widged_type = 'html';
	public $widged_group = 'element';

	public function __construct()
	{
		$this->setWidgedInstance($this);
		$this->setWidgedPath(__DIR__);

		app()->load->language('html/widged');
	}

	public function install($migrate)
	{
		$migrate->add_field(array(
			'id' => array(
				'type' => 'INT',
				'constraint' => 11,
				'unsigned' => TRUE,
				'auto_increment' => TRUE
			),
			'title' => array(
				'type' => 'VARCHAR',
				'constraint' => 200,
			),
			'html' => array(
				'type' => 'TEXT',
			),
			'widged_id' => array(
				'type' => 'INT',
			)
		));
		$migrate->add_key('id', TRUE);
		$migrate->create_table($this->table_name, true);
	}

	public function uninstall($migrate)
	{
		$migrate->drop_table($this->table_name, TRUE);
	}

	/**
	$data = [
		'widged_id',
		'id'
	];
	 */
	public function getWidgedConfig($data)
	{
		return [
			'status' => true,
			'contents' => $this->view('widged_html_setting', $data, true)
		];
	}
	public function config()
	{
		return [
			'grid_min_height' => 1,
			'grid_min_width' => 2,
			'grid_max_height' => 12,
			'grid_max_width' => 12,
			'grid_default_width' => 2,
			'grid_default_height' => 2,
			'icon' => '<img src="' . $this->widgedAssetUrl('asset/img/logo.png') . '" alt="">',
			'description' => "HTML widged",
			'use_box_wrapper' => false
		];
	}

	public function updateValidation($data = [])
	{
		return [
			['title', 'title', 'trim'],
		];
	}

	public function create($data = [])
	{
		return [
			'widged_id' => $data['widged_id'],
			'title' => 'HTML',
			'html' => '',
		];
	}

	public function update($data = [])
	{
		$input = $data['input'];

		return [
			'title' => $input->get('title'),
			'html' => $input->get('html'),
		];
	}

	/**
	$data = [
		'widged_id',
	];
	 */
	public function afterUpdate($data = [], $input)
	{
	}

	public function render($meta)
	{
		$element = function ($widged) use ($meta) {

			$title = $meta->get('title') ? $widged->el('h3', [
				$meta->get('title')
			]) : '';

			return $widged->el(

				'div.html-wrapper#-' . $meta->get('id'),
				[
					$widged->el('div.inner', [
						$widged->el(
							'div',
							$meta->child->get('html')
						),
					]),

				]
			);
		};


		return $this->widged([
			'meta' => $meta,
			'body' => $element
		]);
	}


	public function URLResource()
	{
		return ['uploadHTMLFile', 'getHTMLFile'];
	}

	public function JS()
	{
		return [
			'asset/js/html.js',
		];
	}

	public function CSS()
	{
		return [
			'asset/css/html.css'
		];
	}
}
