<style>
    body {
        margin: 0;
        padding: 0;
    }

    iframe {
        width: 100%;
        height: 99vh;
        border: 0;
        overflow: hidden;
    }

    #fullscreenButton {
        position: absolute;
        margin-top: 13px;
        z-index: 9999;
        right: 20px;
        color: #787878 !important;
        font-size: 18px;
    }
</style>

<div id="fullscreenDiv">

    <a href="#" id="fullscreenButton" class="btn-edit-dashboard"><i class="fa fa-arrows-alt"></i></a>




    <div id="myCarousel" class="carousel slide" data-ride="carousel" data-interval="<?= intval($config->interval * 1000) ?>"> <!-- Set the data-interval attribute to 2000 milliseconds (2 seconds) -->
        <!-- Indicators -->
        <ol class="carousel-indicators">
            <?php foreach ($slides as $idx => $slide) : ?>

                <li data-target="#myCarousel" data-slide-to="<?= $idx ?>" class="<?= $idx == 0 ? 'active' : '' ?>"></li>
            <?php endforeach ?>
        </ol>

        <div class="carousel-inner">
            <?php foreach ($slides as $idx => $slide) : ?>
                <div id="snir_slideshow<?= $idx + 1 ?>" class="item <?= $idx == 0 ? 'active' : '' ?>">
                    <iframe src="<?= admin_url('dashboard/show/' . $slide->slug) ?>?popup=slide"></iframe>
                </div>
            <?php endforeach ?>
        </div>

    </div>
</div>



<script>
    document.addEventListener("DOMContentLoaded", function() {
        var fullscreenDiv = document.getElementById("fullscreenDiv");
        var fullscreenButton = document.getElementById("fullscreenButton");

        fullscreenButton.addEventListener("click", function() {
            if (!document.fullscreenElement) {
                fullscreenDiv.requestFullscreen().catch(function(err) {
                    console.error("Error attempting to enable full-screen mode:", err);
                });
            } else {
                if (document.exitFullscreen) {
                    document.exitFullscreen();
                }
            }
        });
    });
</script>